<?php
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

// Get and validate input
$pincode = isset($_POST['pincode']) ? trim($_POST['pincode']) : '';
$weight = isset($_POST['weight']) ? floatval($_POST['weight']) : 0;

if (!preg_match('/^\d{6}$/', $pincode)) {
    echo json_encode(['success' => false, 'message' => 'Invalid pincode format']);
    exit;
}

if ($weight <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid weight']);
    exit;
}

// Your pickup pincode (replace with your actual pickup location pincode)
$pickupPincode = '395004';

// Shiprocket API credentials
$email = 'drodifytechnology@gmail.com';
$password = '!Ml6nwu1bBr^FVEm';

// Step 1: Authenticate with Shiprocket API
$authData = [
    'email' => $email,
    'password' => $password
];

$authToken = authenticateShiprocket($authData);

if (!$authToken) {
    echo json_encode(['success' => false, 'message' => 'Authentication failed']);
    exit;
}

// Step 2: Check courier serviceability
$couriers = checkCourierServiceability($authToken, $pickupPincode, $pincode, $weight);

if ($couriers === false) {
    echo json_encode(['success' => false, 'message' => 'Failed to check serviceability']);
    exit;
}

echo json_encode([
    'success' => true, 
    'pincode' => $pincode,
    'couriers' => $couriers
]);

// Function to authenticate with Shiprocket
function authenticateShiprocket($authData) {
    $ch = curl_init();
    
    curl_setopt($ch, CURLOPT_URL, "https://apiv2.shiprocket.in/v1/external/auth/login");
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($authData));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json'
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode === 200) {
        $responseData = json_decode($response, true);
        return $responseData['token'] ?? false;
    }
    
    return false;
}

// Function to check courier serviceability
function checkCourierServiceability($token, $pickupPincode, $deliveryPincode, $weight, $cod = 0) {
    $url = "https://apiv2.shiprocket.in/v1/external/courier/serviceability/?";
    $url .= http_build_query([
        'pickup_postcode' => $pickupPincode,
        'delivery_postcode' => $deliveryPincode,
        'weight' => $weight,
        'cod' => $cod
    ]);
    
    $ch = curl_init();
    
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $token,
        'Content-Type: application/json'
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode === 200) {
        $responseData = json_decode($response, true);
        return $responseData['data']['available_courier_companies'] ?? [];
    }
    
    return false;
}
?>