<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Delivery Availability Checker</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: #f5f7fa;
            color: #333;
            line-height: 1.6;
        }
        
        .container {
            max-width: 800px;
            margin: 40px auto;
            padding: 20px;
        }
        
        .card {
            background: white;
            border-radius: 12px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
            padding: 30px;
            margin-bottom: 25px;
            transition: transform 0.3s ease;
        }
        
        .card:hover {
            transform: translateY(-5px);
        }
        
        h1 {
            color: #2c3e50;
            text-align: center;
            margin-bottom: 30px;
            font-weight: 700;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #2c3e50;
        }
        
        input[type="text"] {
            width: 100%;
            padding: 14px;
            border: 1px solid #ddd;
            border-radius: 8px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        
        input[type="text"]:focus {
            border-color: #3498db;
            outline: none;
            box-shadow: 0 0 0 3px rgba(52, 152, 219, 0.2);
        }
        
        button {
            background: #3498db;
            color: white;
            border: none;
            padding: 14px 28px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            font-weight: 600;
            width: 100%;
            transition: background 0.3s;
        }
        
        button:hover {
            background: #2980b9;
        }
        
        .result-container {
            display: none;
            margin-top: 30px;
        }
        
        .result-header {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 15px;
            color: #2c3e50;
        }
        
        .courier-list {
            list-style: none;
        }
        
        .courier-item {
            padding: 15px;
            border-bottom: 1px solid #eee;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .courier-item:last-child {
            border-bottom: none;
        }
        
        .courier-name {
            font-weight: 600;
        }
        
        .courier-details {
            color: #7f8c8d;
            font-size: 14px;
        }
        
        .available {
            color: #27ae60;
            font-weight: 600;
        }
        
        .not-available {
            color: #e74c3c;
            font-weight: 600;
        }
        
        .loader {
            display: none;
            text-align: center;
            margin: 20px 0;
        }
        
        .loader-spinner {
            border: 4px solid #f3f3f3;
            border-top: 4px solid #3498db;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            animation: spin 1s linear infinite;
            margin: 0 auto;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .error-message {
            color: #e74c3c;
            padding: 10px;
            background: #fadbd8;
            border-radius: 6px;
            margin-top: 15px;
            display: none;
        }
        
        .success-message {
            color: #27ae60;
            padding: 10px;
            background: #d5f5e3;
            border-radius: 6px;
            margin-top: 15px;
        }
        
        @media (max-width: 600px) {
            .container {
                padding: 15px;
                margin: 20px auto;
            }
            
            .card {
                padding: 20px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Check Delivery Availability</h1>
        
        <div class="card">
            <form id="deliveryForm">
                <div class="form-group">
                    <label for="pincode">Enter Pincode</label>
                    <input type="text" id="pincode" name="pincode" placeholder="e.g., 395004" maxlength="6" required>
                </div>
                
                <div class="form-group">
                    <label for="weight">Package Weight (kg)</label>
                    <input type="text" id="weight" name="weight" placeholder="e.g., 0.5" required>
                </div>
                
                <button type="submit">Check Availability</button>
            </form>
            
            <div class="loader">
                <div class="loader-spinner"></div>
                <p>Checking availability...</p>
            </div>
            
            <div class="error-message" id="errorMessage"></div>
        </div>
        
        <div class="card result-container" id="resultContainer">
            <div class="result-header" id="resultHeader"></div>
            <ul class="courier-list" id="courierList"></ul>
        </div>
    </div>

    <script>
        document.getElementById('deliveryForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const pincode = document.getElementById('pincode').value;
            const weight = document.getElementById('weight').value;
            const errorMessage = document.getElementById('errorMessage');
            const loader = document.querySelector('.loader');
            const resultContainer = document.getElementById('resultContainer');
            const resultHeader = document.getElementById('resultHeader');
            const courierList = document.getElementById('courierList');
            
            // Reset previous results and errors
            errorMessage.style.display = 'none';
            resultContainer.style.display = 'none';
            courierList.innerHTML = '';
            
            // Validate inputs
            if (!pincode.match(/^\d{6}$/)) {
                errorMessage.textContent = 'Please enter a valid 6-digit pincode';
                errorMessage.style.display = 'block';
                return;
            }
            
            if (!weight.match(/^\d+(\.\d+)?$/) || parseFloat(weight) <= 0) {
                errorMessage.textContent = 'Please enter a valid weight';
                errorMessage.style.display = 'block';
                return;
            }
            
            // Show loader
            loader.style.display = 'block';
            
            // Create AJAX request
            const xhr = new XMLHttpRequest();
            xhr.open('POST', 'check_delivery.php', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            
            xhr.onreadystatechange = function() {
                if (xhr.readyState === 4) {
                    loader.style.display = 'none';
                    
                    if (xhr.status === 200) {
                        try {
                            const response = JSON.parse(xhr.responseText);
                            
                            if (response.success) {
                                resultContainer.style.display = 'block';
                                
                                if (response.couriers && response.couriers.length > 0) {
                                    resultHeader.textContent = `Delivery available to ${pincode} with ${response.couriers.length} courier(s)`;
                                    resultHeader.className = 'result-header available';
                                    
                                    response.couriers.forEach(courier => {
                                        const listItem = document.createElement('li');
                                        listItem.className = 'courier-item';
                                        
                                        listItem.innerHTML = `
                                            <div>
                                                <div class="courier-name">${courier.courier_name}</div>
                                                <div class="courier-details">₹${courier.rate} • ${courier.estimated_delivery_days} days</div>
                                            </div>
                                            <div class="available">Available</div>
                                        `;
                                        
                                        courierList.appendChild(listItem);
                                    });
                                } else {
                                    resultHeader.textContent = `Delivery not available to ${pincode}`;
                                    resultHeader.className = 'result-header not-available';
                                }
                            } else {
                                errorMessage.textContent = response.message || 'Error checking delivery availability';
                                errorMessage.style.display = 'block';
                            }
                        } catch (e) {
                            errorMessage.textContent = 'Error parsing server response';
                            errorMessage.style.display = 'block';
                        }
                    } else {
                        errorMessage.textContent = 'Server error. Please try again later.';
                        errorMessage.style.display = 'block';
                    }
                }
            };
            
            xhr.send(`pincode=${encodeURIComponent(pincode)}&weight=${encodeURIComponent(weight)}`);
        });
    </script>
</body>
</html>