<?php
/* ------------------- Create Class For API Integration ------------------- */
class ShiprocketAPI {
    private $user_name; 
    private $password; 
    
    public function __construct() {
        $this->user_name = "drodifytechnology@gmail.com";
        $this->password = "!Ml6nwu1bBr^FVEm";
    }
    
    # Validate your API user and get token
    function getToken() {
        $user = [
            "email" => $this->user_name,
            "password" => $this->password,
        ];
        
        # Array to JSON
        $login_user = json_encode($user);
        
        $curl = curl_init();
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://apiv2.shiprocket.in/v1/external/auth/login",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $login_user,
            CURLOPT_HTTPHEADER => array(
                "Content-Type: application/json"
            ),
        ));
        
        $response = curl_exec($curl);
        curl_close($curl);
        
        $res = json_decode($response);
        
        if (isset($res->token)) {
            $result = [
                "status" => true,
                "token" => $res->token,
            ];
        } else {  
            $result = [
                "status" => false,
                "message" => $res->message ?? "Unknown error occurred",
            ];
        }
        return $result;
    }
    
    # Check Courier Serviceability and Calculate Courier Charges
    function checkCourierAvailAndRate($details) {
        $result = $this->getToken();
        
        if ($result["status"]) {
            $curl = curl_init();
            
            // Build query string from details array
            $queryString = http_build_query($details);
            
            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://apiv2.shiprocket.in/v1/external/courier/serviceability/?" . $queryString,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => array(
                    "Content-Type: application/json",
                    "Authorization: Bearer {$result["token"]}"
                ),
            ));
            
            $response = curl_exec($curl);
            $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            curl_close($curl);
            
            $res = json_decode($response);
            
            if ($httpCode === 200) {
                return $res;
            } else {
                return [
                    "status" => false,
                    "message" => $res->message ?? "API request failed with HTTP code: " . $httpCode,
                ];
            }
        } else {
            return [
                "status" => false,
                "message" => $result["message"],
            ];
        }
    }
    
    # Check International Courier Serviceability and Calculate Courier Charges
    function checkInternationalCourierAvailAndRate($details) {
        $result = $this->getToken();
        
        if ($result["status"]) {
            $curl = curl_init();
            
            // Build query string from details array
            $queryString = http_build_query($details);
            
            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://apiv2.shiprocket.in/v1/external/courier/international/serviceability?" . $queryString,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => array(
                    "Content-Type: application/json",
                    "Authorization: Bearer {$result["token"]}"
                ),
            ));
            
            $response = curl_exec($curl);
            $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            curl_close($curl);
            
            $res = json_decode($response);
            
            if ($httpCode === 200) {
                return $res;
            } else {
                return [
                    "status" => false,
                    "message" => $res->message ?? "API request failed with HTTP code: " . $httpCode,
                ];
            }
        } else {
            return [
                "status" => false,
                "message" => $result["message"],
            ];
        }
    }
}

# Geocoding class to convert coordinates to pincodes
class GeocodingService {
    # In a production environment, you would use a proper geocoding API
    # For demonstration, we'll simulate the conversion with a simple function
    
    public function convertCoordinatesToPincode($lat, $lng) {
        // This is a simulation - in reality, you would call a geocoding API
        // For this demo, we'll return pincodes based on the coordinate values
        
        // Simple simulation - return different pincodes based on lat/lng values
        $lat_int = (int)abs($lat);
        $lng_int = (int)abs($lng);
        
        // Create a "pincode" based on the coordinates
        $pincode = sprintf("%d%02d", $lat_int % 100, $lng_int % 100);
        
        // Ensure it's a 6-digit pincode
        $pincode = str_pad($pincode, 6, '0', STR_PAD_LEFT);
        
        return $pincode;
    }
}

// Set content type to JSON
header('Content-Type: application/json');

// Check if it's a POST request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get the raw POST data
    $postData = $_POST;
    
    // Initialize the API class
    $shiprocket = new ShiprocketAPI();
    $geocoding = new GeocodingService();
    
    // Determine which action to take
    $action = $_POST['action'] ?? '';
    
    // Check if we're using coordinates or pincodes
    $usingCoordinates = isset($_POST['pickup_lat']) && isset($_POST['pickup_lng']) && 
                        isset($_POST['delivery_lat']) && isset($_POST['delivery_lng']);
    
    if ($usingCoordinates) {
        // Convert coordinates to pincodes
        $pickupPincode = $geocoding->convertCoordinatesToPincode($_POST['pickup_lat'], $_POST['pickup_lng']);
        $deliveryPincode = $geocoding->convertCoordinatesToPincode($_POST['delivery_lat'], $_POST['delivery_lng']);
        
        // Store the converted pincodes for the response
        $convertedPincodes = [
            'pickup_pincode' => $pickupPincode,
            'delivery_pincode' => $deliveryPincode
        ];
    } else {
        $pickupPincode = $_POST['pickup_postcode'] ?? '636005';
        $deliveryPincode = $_POST['delivery_postcode'] ?? '630001';
        $convertedPincodes = null;
    }
    
    if ($action === 'domestic') {
        // Prepare domestic shipment details
        $details = [
            "pickup_postcode" => $pickupPincode,
            "delivery_postcode" => $deliveryPincode,
            "cod" => $_POST['cod'] ?? 1,
            "weight" => $_POST['weight'] ?? 1,
            "mode" => $_POST['mode'] ?? "Surface",
        ];
        
        // Get domestic courier serviceability
        $result = $shiprocket->checkCourierAvailAndRate($details);
        
        // Add converted pincodes to response if we used coordinates
        if ($usingCoordinates && $convertedPincodes) {
            $result->converted_pincodes = $convertedPincodes;
        }
        
        echo json_encode($result);
        
    } elseif ($action === 'international') {
        // Prepare international shipment details
        $details = [
            "pickup_postcode" => $pickupPincode,
            "delivery_country" => $_POST['delivery_country'] ?? 'US',
            "cod" => 0, // Must be 0 for international
            "weight" => $_POST['weight'] ?? 1.5,
        ];
        
        // Get international courier serviceability
        $result = $shiprocket->checkInternationalCourierAvailAndRate($details);
        
        // Add converted pincodes to response if we used coordinates
        if ($usingCoordinates && $convertedPincodes) {
            $result->converted_pincodes = $convertedPincodes;
        }
        
        echo json_encode($result);
        
    } else {
        // Invalid action
        echo json_encode([
            "status" => false,
            "message" => "Invalid action specified"
        ]);
    }
} else {
    // Not a POST request
    echo json_encode([
        "status" => false,
        "message" => "Only POST requests are allowed"
    ]);
}
?>