<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Shiprocket Courier Serviceability</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: #f5f7fa;
            color: #333;
            line-height: 1.6;
            padding: 20px;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
        }
        
        header {
            text-align: center;
            margin-bottom: 30px;
            padding: 20px;
            background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
            color: white;
            border-radius: 10px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }
        
        h1 {
            font-size: 2.5rem;
            margin-bottom: 10px;
        }
        
        .subtitle {
            font-size: 1.1rem;
            opacity: 0.9;
        }
        
        .controls {
            background-color: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.05);
            margin-bottom: 30px;
        }
        
        .form-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
        }
        
        .form-group {
            margin-bottom: 15px;
        }
        
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: 600;
            color: #444;
        }
        
        input, select {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 6px;
            font-size: 16px;
        }
        
        button {
            background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 16px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        button:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.15);
        }
        
        .results {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .card {
            background-color: white;
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.05);
            padding: 20px;
            transition: transform 0.3s ease;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 15px rgba(0, 0, 0, 0.1);
        }
        
        .card-header {
            border-bottom: 1px solid #eee;
            padding-bottom: 15px;
            margin-bottom: 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .courier-name {
            font-size: 1.4rem;
            font-weight: 700;
            color: #2575fc;
        }
        
        .rate {
            font-size: 1.8rem;
            font-weight: 700;
            color: #2ecc71;
            text-align: center;
            margin: 15px 0;
        }
        
        .detail-item {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
            padding-bottom: 10px;
            border-bottom: 1px dashed #eee;
        }
        
        .detail-label {
            color: #777;
            font-weight: 500;
        }
        
        .detail-value {
            font-weight: 600;
        }
        
        .error {
            background-color: #ffebee;
            color: #d32f2f;
            padding: 15px;
            border-radius: 6px;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .loading {
            text-align: center;
            padding: 40px;
            font-size: 1.2rem;
            color: #777;
        }
        
        .loading::after {
            content: "";
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid rgba(37, 117, 252, 0.3);
            border-radius: 50%;
            border-top-color: #2575fc;
            animation: spin 1s ease-in-out infinite;
            margin-left: 10px;
            vertical-align: middle;
        }
        
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        
        footer {
            text-align: center;
            margin-top: 40px;
            color: #777;
            font-size: 0.9rem;
        }
        
        @media (max-width: 768px) {
            .form-grid {
                grid-template-columns: 1fr;
            }
            
            h1 {
                font-size: 2rem;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <header>
            <h1>Shiprocket Courier Serviceability</h1>
            <p class="subtitle">Check available courier services and rates</p>
        </header>
        
        <div class="controls">
            <h2>Check Serviceability</h2>
            <p>Enter shipment details to check available courier options</p>
            
            <div class="form-grid">
                <div class="form-group">
                    <label for="pickupPostcode">Pickup Postcode</label>
                    <input type="text" id="pickupPostcode" value="636005" placeholder="Enter pickup postcode">
                </div>
                
                <div class="form-group">
                    <label for="deliveryPostcode">Delivery Postcode</label>
                    <input type="text" id="deliveryPostcode" value="630001" placeholder="Enter delivery postcode">
                </div>
                
                <div class="form-group">
                    <label for="weight">Weight (kg)</label>
                    <input type="number" id="weight" value="1" step="0.1" min="0.1" placeholder="Enter weight">
                </div>
                
                <div class="form-group">
                    <label for="cod">COD</label>
                    <select id="cod">
                        <option value="1">Cash on Delivery</option>
                        <option value="0">Prepaid</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label for="mode">Mode</label>
                    <select id="mode">
                        <option value="Surface">Surface</option>
                        <option value="Air">Air</option>
                    </select>
                </div>
            </div>
            
            <button id="checkServiceability">Check Serviceability</button>
        </div>
        
        <div id="resultsContainer">
            <!-- Results will be displayed here -->
        </div>
        
        <footer>
            <p>Powered by Shiprocket API | &copy; 2023 Courier Serviceability Checker</p>
        </footer>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const checkButton = document.getElementById('checkServiceability');
            const resultsContainer = document.getElementById('resultsContainer');
            
            checkButton.addEventListener('click', function() {
                // Show loading state
                resultsContainer.innerHTML = '<div class="loading">Checking serviceability</div>';
                
                // Get form values
                const pickupPostcode = document.getElementById('pickupPostcode').value;
                const deliveryPostcode = document.getElementById('deliveryPostcode').value;
                const weight = document.getElementById('weight').value;
                const cod = document.getElementById('cod').value;
                const mode = document.getElementById('mode').value;
                
                // Make AJAX request to our PHP backend
                fetch('check_pickup.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: `action=domestic&pickup_postcode=${pickupPostcode}&delivery_postcode=${deliveryPostcode}&weight=${weight}&cod=${cod}&mode=${mode}`
                })
                .then(response => response.json())
                .then(data => {
                    displayResults(data);
                })
                .catch(error => {
                    resultsContainer.innerHTML = `
                        <div class="error">
                            <p>An error occurred while fetching data. Please try again.</p>
                            <p>${error.message}</p>
                        </div>
                    `;
                });
            });
            
            function displayResults(data) {
                if (data.status === false) {
                    resultsContainer.innerHTML = `
                        <div class="error">
                            <p>${data.message || 'Failed to retrieve data from API'}</p>
                        </div>
                    `;
                    return;
                }
                
                if (!data.data || data.data.available_courier_companies.length === 0) {
                    resultsContainer.innerHTML = `
                        <div class="error">
                            <p>No courier services available for the provided details.</p>
                        </div>
                    `;
                    return;
                }
                
                let html = '<h2>Available Courier Services</h2><div class="results">';
                
                data.data.available_courier_companies.forEach(courier => {
                    html += `
                        <div class="card">
                            <div class="card-header">
                                <span class="courier-name">${courier.courier_name}</span>
                            </div>
                            <div class="rate">₹${courier.rate}</div>
                            <div class="card-body">
                                <div class="detail-item">
                                    <span class="detail-label">Estimated Delivery:</span>
                                    <span class="detail-value">${courier.etd}</span>
                                </div>
                                <div class="detail-item">
                                    <span class="detail-label">Courier Company ID:</span>
                                    <span class="detail-value">${courier.courier_company_id}</span>
                                </div>
                                <div class="detail-item">
                                    <span class="detail-label">Weight Charge:</span>
                                    <span class="detail-value">₹${courier.freight_charge}</span>
                                </div>
                                <div class="detail-item">
                                    <span class="detail-label">Fuel Surcharge:</span>
                                    <span class="detail-value">₹${courier.fuel_surcharge}</span>
                                </div>
                                <div class="detail-item">
                                    <span class="detail-label">COD Charge:</span>
                                    <span class="detail-value">₹${courier.cod_charge}</span>
                                </div>
                                <div class="detail-item">
                                    <span class="detail-label">Min Weight:</span>
                                    <span class="detail-value">${courier.min_weight} kg</span>
                                </div>
                                <div class="detail-item">
                                    <span class="detail-label">Max Weight:</span>
                                    <span class="detail-value">${courier.max_weight} kg</span>
                                </div>
                            </div>
                        </div>
                    `;
                });
                
                html += '</div>';
                resultsContainer.innerHTML = html;
            }
            
            // Trigger initial load
            checkButton.click();
        });
    </script>
</body>
</html>