<?php 
// Include configuration file 
include_once 'config.php'; 
 
function sendSMS($mobile_no, $message) { 
    // URL encode the message
    $message = urldecode($message);
    
    // Request parameters array  
    $requestParams = array(  
        'username' => USER_NAME,
        'message' => $message,   
        'sendername' => SENDER_ID, 
        'smstype' => MSG_TYPE,  
        'numbers' => $mobile_no,   
        'apikey' => API_KEY
    );  
    
    // Append parameters to API URL  
    $apiURL = API_URL . '?' . http_build_query($requestParams);
     
    // Send the GET request with cURL  
    $ch = curl_init();  
    curl_setopt($ch, CURLOPT_URL, $apiURL);  
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);  
    $response = curl_exec($ch);  
    curl_close($ch);  
     
    // Return API response 
    return $response; 
} 
 
// Load and initialize database class 
require_once 'DB.class.php'; 
$db = new DB(); 
         
$statusMsg = $receipient_no = ''; 
$otpDisplay = $verified = 0; 
 
// If mobile number submitted by the user 
if(isset($_POST['submit_mobile']) || isset($_POST['resend_otp'])){ 
    // Recipient mobile number 
    $receiver = $_POST['mobile_no']; 
 
    if(!empty($receiver) && preg_match('/^[0-9]{10}+$/', $receiver)){ 
        // Generate 4 digits random verification code 
        $rand_no = rand(1000, 9999); 
         
        // Check previous entry 
        $conditions = array( 
            'mobile_number' => $receiver, 
        ); 
        $checkPrev = $db->checkRow($conditions); 
         
        // Insert or update otp in the database 
        if($checkPrev){ 
            $otpData = array( 
                'verification_code' => $rand_no 
            ); 
            $insert = $db->update($otpData, $conditions); 
        }else{ 
            $otpData = array( 
                'mobile_number' => $receiver, 
                'verification_code' => $rand_no, 
                'verified' => 0 
            ); 
            $insert = $db->insert($otpData); 
        } 
         
        if($insert){ 
            // Send otp to user via SMS 
            $message = ''.$rand_no.'. is the OTP for Dhani. Please do not share this OTP with anyone. This SMS has been sent from GuestRAR.'; 
            $send = sendSMS($receiver, $message); 
            if($send){ 
                $otpDisplay = 1; 
                $statusMsg = array( 
                    'status' => 'success', 
                    'msg' => "OTP has been successfully sent to your mobile no." 
                ); 
            }else{ 
                $statusMsg = array( 
                    'status' => 'error', 
                    'msg' => "We're facing some issues with sending SMS, please try again." 
                ); 
            } 
        }else{ 
            $statusMsg = array( 
                'status' => 'error', 
                'msg' => 'Something went wrong, please try again.' 
            ); 
        } 
    }else{ 
        $statusMsg = array( 
            'status' => 'danger', 
            'msg' => 'Please enter a valid mobile number.' 
        ); 
    } 
// If verification code submitted by the user 
}elseif(isset($_POST['submit_otp']) && !empty($_POST['mobile_no'])){ 
    $otpDisplay = 1; 
    $receiver = $_POST['mobile_no']; 
    $otp_code = $_POST['otp_code']; 
 
    if(!empty($otp_code)){ 
        // Verify otp code 
        $conditions = array( 
            'mobile_number' => $receiver, 
            'verification_code' => $otp_code 
        ); 
        $check = $db->checkRow($conditions); 
         
        if($check){ 
            $otpData = array( 
                'verified' => 1 
            ); 
            $update = $db->update($otpData, $conditions); 
             
            $statusMsg = array( 
                'status' => 'success', 
                'msg' => 'Thank you! Your phone number has been verified successfully.' 
            ); 
             
            $verified = 1; 
        }else{ 
            $statusMsg = array( 
                'status' => 'danger', 
                'msg' => 'Given verification code is incorrect, please try again.' 
            ); 
        } 
    }else{ 
        $statusMsg = array( 
            'status' => 'warning', 
            'msg' => 'Please enter the verification code.' 
        ); 
    } 
}