<?php
// submit_form.php

// Include your database connection
include 'db_connect.php'; // $con should be the mysqli connection

date_default_timezone_set("Asia/Kolkata");

// Function to handle file upload and return saved file path
function uploadFile($file, $uploadDir = 'uploads/') {
    if (!isset($file) || $file['error'] == UPLOAD_ERR_NO_FILE) {
        return null; // No file uploaded
    }

    // Create upload directory if it doesn't exist
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

    $filename = time() . '_' . basename($file['name']);
    $targetFilePath = $uploadDir . $filename;

    if (move_uploaded_file($file['tmp_name'], $targetFilePath)) {
        return $targetFilePath;
    } else {
        return null; // Failed upload
    }
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {

    // Personal Information
    $first_name = mysqli_real_escape_string($con, $_POST['first_name']);
    $last_name = mysqli_real_escape_string($con, $_POST['last_name']);
    $father_name = mysqli_real_escape_string($con, $_POST['father_name']);
    $dob = $_POST['dob'];
    $gender = $_POST['gender'];
    $caste = $_POST['caste'];

    // Permanent Address
    $residential_address = mysqli_real_escape_string($con, $_POST['residential_address']);
    $residential_city = mysqli_real_escape_string($con, $_POST['residential_city']);
    $residential_district = mysqli_real_escape_string($con, $_POST['residential_district']);
    $residential_state = $_POST['residential_state'];
    $residential_pincode = $_POST['residential_pincode'];
    $mobile = $_POST['mobile'];
    $altmobile = $_POST['altmobile'];
    $email = $_POST['email'];
    $aadhar_number = $_POST['aadhar_number'];
    $pan_number = $_POST['pan_number'];

    // Business Information
    $business_type = $_POST['business_type'];
    $shop_name = mysqli_real_escape_string($con, $_POST['shop_name']);
    $shop_no = mysqli_real_escape_string($con, $_POST['shop_no']);
    $business_address = mysqli_real_escape_string($con, $_POST['business_address']);
    $business_city = mysqli_real_escape_string($con, $_POST['business_city']);
    $business_district = mysqli_real_escape_string($con, $_POST['business_district']);
    $business_state = $_POST['business_state'];
    $business_pincode = $_POST['business_pincode'];
    $propertytype = $_POST['propertytype'];
    $occupation = $_POST['occupation'];
    $partnership = $_POST['partnership'];
    $agreement_tenure = $_POST['agreement_tenure'];

    // Area Size
    $shop_frontage = $_POST['shop_frontage'];
    $shop_depth = $_POST['shop_depth'];
    $office_frontage = $_POST['office_frontage'] ?? null;
    $office_depth = $_POST['office_depth'] ?? null;
    $godown_frontage = $_POST['godown_frontage'] ?? null;
    $godown_depth = $_POST['godown_depth'] ?? null;

    // Investment & Payment
    $investment_parlour = $_POST['investment_parlour'];
    $investment_scoop = $_POST['investment_scoop'];
    $investment_distributor = $_POST['investment_distributor'];
    $payment_mode = $_POST['payment_mode'];

    // Bank Details
    $account_holder_name = $_POST['account_holder_name'];
    $account_number = $_POST['account_number'];
    $ifsc_code = $_POST['ifsc_code'];
    $bank_name = $_POST['bank_name'];
    $branch_name = $_POST['branch_name'];

    // File uploads
    $aadhar_card = uploadFile($_FILES['aadhar_card']);
    $pan_card = uploadFile($_FILES['pan_card']);
    $shoprentagreement = uploadFile($_FILES['shoprentagreement']);
    $electricbill = uploadFile($_FILES['electricbill']);
    $shop_front_picture = uploadFile($_FILES['shop_front_picture']);
    $bankstatement = uploadFile($_FILES['bankstatement']);
    $cancelcheck = uploadFile($_FILES['cancelcheck']);
    $passport_picture = uploadFile($_FILES['passport_picture']);
    $gst = uploadFile($_FILES['gst']);
    $fssai = uploadFile($_FILES['fssai']);

    // Insert data into database
    $sql = "INSERT INTO amul_registration (
        first_name, last_name, father_name, dob, gender, caste,
        residential_address, residential_city, residential_district, residential_state, residential_pincode,
        mobile, altmobile, email, aadhar_number, pan_number,
        business_type, shop_name, shop_no, business_address, business_city, business_district, business_state, business_pincode,
        propertytype, occupation, partnership, agreement_tenure,
        shop_frontage, shop_depth, office_frontage, office_depth, godown_frontage, godown_depth,
        investment_parlour, investment_scoop, investment_distributor, payment_mode,
        account_holder_name, account_number, ifsc_code, bank_name, branch_name,
        aadhar_card, pan_card, shoprentagreement, electricbill, shop_front_picture, bankstatement, cancelcheck, passport_picture, gst, fssai,
        submission_date
    ) VALUES (
        '$first_name', '$last_name', '$father_name', '$dob', '$gender', '$caste',
        '$residential_address', '$residential_city', '$residential_district', '$residential_state', '$residential_pincode',
        '$mobile', '$altmobile', '$email', '$aadhar_number', '$pan_number',
        '$business_type', '$shop_name', '$shop_no', '$business_address', '$business_city', '$business_district', '$business_state', '$business_pincode',
        '$propertytype', '$occupation', '$partnership', '$agreement_tenure',
        '$shop_frontage', '$shop_depth', '$office_frontage', '$office_depth', '$godown_frontage', '$godown_depth',
        '$investment_parlour', '$investment_scoop', '$investment_distributor', '$payment_mode',
        '$account_holder_name', '$account_number', '$ifsc_code', '$bank_name', '$branch_name',
        '$aadhar_card', '$pan_card', '$shoprentagreement', '$electricbill', '$shop_front_picture', '$bankstatement', '$cancelcheck', '$passport_picture', '$gst', '$fssai',
        NOW()
    )";

    if (mysqli_query($con, $sql)) {
        echo json_encode(['status' => 'success', 'message' => 'Registration submitted successfully.']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Database error: '.mysqli_error($con)]);
    }
}
?>
